#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/ssl/header.h"
#include "levels/bbh/header.h"

extern u8 _ssl_segment_ESegmentRomStart[];
extern u8 _ssl_segment_ESegmentRomEnd[];

const LevelScript level_ssl_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _bbh_segment_7SegmentRomStart, _bbh_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _bbhSegmentRomStart, _bbhSegmentRomEnd),
LOAD_RAW(0x0E, _ssl_segment_ESegmentRomStart, _ssl_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _ssl_skybox_mio0SegmentRomStart, _ssl_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group9_mio0SegmentRomStart, _group9_mio0SegmentRomEnd),
LOAD_RAW(12, _group9_geoSegmentRomStart, _group9_geoSegmentRomEnd),
LOAD_MIO0(6, _group17_mio0SegmentRomStart, _group17_mio0SegmentRomEnd),
LOAD_RAW(13, _group17_geoSegmentRomStart, _group17_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_BBH_HAUNTED_DOOR,           haunted_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_BBH_STAIRCASE_STEP,         geo_bbh_0005B0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TILTING_FLOOR_PLATFORM, geo_bbh_0005C8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM,      geo_bbh_0005E0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM_PART, geo_bbh_0005F8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MOVING_BOOKSHELF,       geo_bbh_000610),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MESH_ELEVATOR,          geo_bbh_000628),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MERRY_GO_ROUND,         geo_bbh_000640),
LOAD_MODEL_FROM_GEO(MODEL_BBH_WOODEN_TOMB,            geo_bbh_000658),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_10),
JUMP_LINK(script_func_global_18),
JUMP_LINK(local_area_ssl_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_ssl_1_[] = {
AREA(1, Geo_ssl_1_0x1585d40),
TERRAIN(col_ssl_1_0xe02fc00),
SET_BACKGROUND_MUSIC(0, 52),
TERRAIN_TYPE(3),
JUMP_LINK(local_objects_ssl_1_),
JUMP_LINK(local_warps_ssl_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_ssl_1_[] = {
OBJECT_WITH_ACTS(0, 1004, 2599, -4959, 0, 90, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(122, 5973, 4410, -271, 0, 0, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(137, 3514, 3090, -9584, 0, 0, 0, 0xa0000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(122, 12188, 4170, -2413, 0, 0, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 1196, 2965, -14055, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(137, 12569, 1410, -7360, 0, 0, 0, 0xd0000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 14512, 2765, -6805, 0, 0, 0, 0x5000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(215, 1914, 1740, -224, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 2197, 5400, -14673, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 625, 1600, -10550, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 2721, 2010, -14896, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 4157, 2145, -12568, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 8231, 2340, -1576, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 10098, 860, -10459, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 11654, 4309, -11434, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(223, 667, 1500, -8546, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(212, 8641, 4180, -11208, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(0, 6113, 1500, -8393, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, 14503, 1500, -1388, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 12389, 4000, -8670, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 12394, 4000, -7817, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 12404, 4000, -6945, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 10917, 4000, -8667, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 10908, 4000, -7804, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 10883, 4000, -6936, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 632, 1500, -8442, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(124, 720, 4000, -13270, 0, 0, 0, 0x2a0000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(137, 14634, 4240, -11168, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(129, 3360, 2040, -9710, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(129, 3560, 2040, -9710, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(129, 3360, 2040, -9510, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(129, 3560, 2040, -9510, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(0, 880, 2790, -12223, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(84, 260, 4260, -14649, 0, 0, 0, 0x0,  bhvBoo, 31),
OBJECT_WITH_ACTS(0, 772, 1650, -1129, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(206, 13164, 2790, -2109, 0, 0, 0, 0x0,  bhvSnufit, 31),
OBJECT_WITH_ACTS(0, 8757, 2250, -13876, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(223, 12151, 500, -11834, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 10893, 500, -11902, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(180, 13406, 720, -9094, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 13133, 870, -7866, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(137, 3668, 1995, -5505, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 3489, 1500, -9663, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(206, 13200, 2490, -892, 0, 0, 0, 0x0,  bhvSnufit, 31),
OBJECT_WITH_ACTS(137, 1006, 5105, -13789, 0, 0, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 14781, 2640, -14746, 0, 0, 0, 0x40000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 1164, 1500, -3417, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, 6819, 1816, -10358, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, 13885, 2250, -8683, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(27, 1196, 1500, -7951, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(27, 1810, 1500, -11724, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(27, 260, 1500, -9816, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(0, 7123, 2589, -1809, 0, 337, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(129, 1196, 3990, -14229, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(223, 9921, 2250, -8362, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(0, 10636, 1625, -3205, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 4234, 1500, -11516, 0, 270, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(137, 11517, 1930, -375, 0, 0, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 13191, 1410, -12495, 0, 0, 0, 0x60000,  bhvExclamationBox, 31),
RETURN()
};

const LevelScript local_warps_ssl_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(240, 6, 2, 42, 0),
WARP_NODE(241, 6, 2, 52, 0),
RETURN()
};
